<?php
// public/search.php - Search results page
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/db.php';
$db = get_db();

$search = trim($_GET['q'] ?? '');
$berita_results = $download_results = $guru_results = [];
if ($search !== '') {
  // Search Berita
  $stmt = $db->prepare("SELECT id, title, kategori, content, date, author, image FROM berita WHERE title LIKE ? OR content LIKE ? ORDER BY date DESC LIMIT 5");
  $stmt->execute(['%' . $search . '%', '%' . $search . '%']);
  $berita_results = $stmt->fetchAll(PDO::FETCH_ASSOC);
  // Search Download
  $stmt = $db->prepare("SELECT id, title, kategori, description, file, date FROM download WHERE title LIKE ? OR description LIKE ? ORDER BY date DESC LIMIT 5");
  $stmt->execute(['%' . $search . '%', '%' . $search . '%']);
  $download_results = $stmt->fetchAll(PDO::FETCH_ASSOC);
  // Search Guru
  $stmt = $db->prepare("SELECT id, name, subject, photo FROM teachers WHERE name LIKE ? OR subject LIKE ? ORDER BY name ASC LIMIT 5");
  $stmt->execute(['%' . $search . '%', '%' . $search . '%']);
  $guru_results = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
include '_header.php';
?>
<div class="container py-4">
  <h1 class="mb-4">Hasil Pencarian</h1>
  <form class="row g-2 mb-4" method="get" action="search.php">
    <div class="col-md-8 col-lg-6">
      <input type="text" class="form-control form-control-lg" name="q" placeholder="Cari berita, file, guru..." value="<?php echo e($search); ?>">
    </div>
    <div class="col-auto">
      <button class="btn btn-primary btn-lg" type="submit"><i class="fa fa-search"></i> Cari</button>
    </div>
  </form>
  <?php if ($search !== ''): ?>
    <h2 class="h5 mb-3">Hasil untuk: <mark><?php echo e($search); ?></mark></h2>
    <?php if (empty($berita_results) && empty($download_results) && empty($guru_results)): ?>
      <div class="alert alert-warning">Tidak ada hasil ditemukan.</div>
    <?php endif; ?>
    <?php if (!empty($berita_results)): ?>
      <h5 class="mt-4">Berita</h5>
      <ul class="list-group mb-3">
        <?php foreach ($berita_results as $b): ?>
          <li class="list-group-item">
            <a href="berita_detail.php?id=<?php echo $b['id']; ?>" class="fw-bold"><?php echo e($b['title']); ?></a>
            <span class="badge bg-info text-dark ms-2"><?php echo e($b['kategori'] ?? '-'); ?></span>
            <div class="small text-muted">Tanggal: <?php echo e($b['date']); ?> | Author: <?php echo e($b['author']); ?></div>
            <div class="small mt-1" style="max-width:600px;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;">
              <?php echo nl2br(e(mb_substr(strip_tags($b['content']),0,100))) . (mb_strlen(strip_tags($b['content']))>100?'...':''); ?>
            </div>
          </li>
        <?php endforeach; ?>
      </ul>
    <?php endif; ?>
    <?php if (!empty($download_results)): ?>
      <h5 class="mt-4">File Download</h5>
      <ul class="list-group mb-3">
        <?php foreach ($download_results as $d): ?>
          <li class="list-group-item">
            <a href="../data/uploads/<?php echo e($d['file']); ?>" target="_blank" class="fw-bold"><i class="fa fa-download"></i> <?php echo e($d['title']); ?></a>
            <span class="badge bg-info text-dark ms-2"><?php echo e($d['kategori'] ?? '-'); ?></span>
            <div class="small text-muted">Tanggal: <?php echo e($d['date']); ?></div>
            <div class="small mt-1" style="max-width:600px;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;">
              <?php echo nl2br(e(mb_substr(strip_tags($d['description']),0,100))) . (mb_strlen(strip_tags($d['description']))>100?'...':''); ?>
            </div>
          </li>
        <?php endforeach; ?>
      </ul>
    <?php endif; ?>
    <?php if (!empty($guru_results)): ?>
      <h5 class="mt-4">Guru</h5>
      <ul class="list-group mb-3">
        <?php foreach ($guru_results as $g): ?>
          <li class="list-group-item">
            <?php if (!empty($g['photo'])): ?><img src="../data/uploads/teachers/<?php echo e($g['photo']); ?>" alt="Foto" class="rounded me-2" style="width:32px;height:32px;object-fit:cover;vertical-align:middle;"><?php endif; ?>
            <span class="fw-bold"><?php echo e($g['name']); ?></span>
            <span class="text-muted ms-2">(<?php echo e($g['subject']); ?>)</span>
          </li>
        <?php endforeach; ?>
      </ul>
    <?php endif; ?>
  <?php endif; ?>
</div>
<?php include '_footer.php'; ?>
