<?php
require_once __DIR__ . '/../includes/db.php';

$id = $_GET['id'] ?? 0;
$db = get_db();

try {
    $stmt = $db->prepare("SELECT * FROM student_registrations WHERE id = ?");
    $stmt->execute([$id]);
    $reg = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$reg) {
        die('Data tidak ditemukan');
    }
    
    // Get settings
    $settingsStmt = $db->query("SELECT key, value FROM settings WHERE key LIKE 'site_%' OR key LIKE 'ppdb_%'");
    $settings = [];
    while ($row = $settingsStmt->fetch(PDO::FETCH_ASSOC)) {
        $settings[$row['key']] = $row['value'];
    }
} catch (Exception $e) {
    die('Error: ' . $e->getMessage());
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Kartu Pendaftaran - <?php echo htmlspecialchars($reg['registration_number']); ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: Arial, sans-serif; padding: 20px; }
        .card { border: 2px solid #000; padding: 20px; max-width: 800px; margin: 0 auto; }
        .header { text-align: center; border-bottom: 3px solid #000; padding-bottom: 15px; margin-bottom: 20px; }
        .header h1 { font-size: 24px; margin: 10px 0; }
        .header h2 { font-size: 18px; margin: 5px 0; }
        .title { text-align: center; background: #000; color: #fff; padding: 10px; margin: 20px 0; font-size: 18px; font-weight: bold; }
        .info-row { display: flex; margin: 10px 0; }
        .info-label { width: 200px; font-weight: bold; }
        .info-value { flex: 1; }
        .section { margin: 20px 0; }
        .section-title { background: #f0f0f0; padding: 8px; font-weight: bold; margin: 15px 0 10px 0; }
        .status { display: inline-block; padding: 5px 15px; border-radius: 3px; font-weight: bold; }
        .status-pending { background: #ffc107; color: #000; }
        .status-verified { background: #17a2b8; color: #fff; }
        .status-accepted { background: #28a745; color: #fff; }
        .status-rejected { background: #dc3545; color: #fff; }
        .footer { margin-top: 40px; text-align: right; }
        .signature { display: inline-block; text-align: center; margin-top: 60px; }
        .signature-line { border-top: 1px solid #000; padding-top: 5px; min-width: 200px; }
        @media print {
            body { padding: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="no-print" style="text-align: center; margin-bottom: 20px;">
        <button onclick="window.print()" style="padding: 10px 20px; font-size: 16px; cursor: pointer;">
            🖨️ Cetak Kartu
        </button>
        <button onclick="window.close()" style="padding: 10px 20px; font-size: 16px; cursor: pointer; margin-left: 10px;">
            ❌ Tutup
        </button>
    </div>
    
    <div class="card">
        <!-- Header -->
        <div class="header">
            <h1><?php echo htmlspecialchars($settings['site_name'] ?? 'SEKOLAH'); ?></h1>
            <h2>KARTU PENDAFTARAN PESERTA DIDIK BARU</h2>
            <p>Tahun Ajaran <?php echo htmlspecialchars($settings['ppdb_year'] ?? '-'); ?></p>
        </div>
        
        <!-- Registration Number -->
        <div class="title">
            NO. PENDAFTARAN: <?php echo htmlspecialchars($reg['registration_number']); ?>
        </div>
        
        <!-- Status -->
        <div style="text-align: center; margin: 15px 0;">
            <?php
            $statusClass = ['pending' => 'pending', 'verified' => 'verified', 'accepted' => 'accepted', 'rejected' => 'rejected'];
            $statusLabel = ['pending' => 'PENDING', 'verified' => 'TERVERIFIKASI', 'accepted' => 'DITERIMA', 'rejected' => 'DITOLAK'];
            ?>
            <span class="status status-<?php echo $statusClass[$reg['status']]; ?>">
                STATUS: <?php echo $statusLabel[$reg['status']]; ?>
            </span>
        </div>
        
        <!-- Data Pribadi -->
        <div class="section">
            <div class="section-title">DATA PRIBADI</div>
            <div class="info-row">
                <div class="info-label">Nama Lengkap</div>
                <div class="info-value">: <?php echo htmlspecialchars($reg['full_name']); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Jenis Kelamin</div>
                <div class="info-value">: <?php echo $reg['gender'] === 'L' ? 'Laki-laki' : 'Perempuan'; ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Tempat, Tanggal Lahir</div>
                <div class="info-value">: <?php echo htmlspecialchars($reg['birth_place']) . ', ' . date('d-m-Y', strtotime($reg['birth_date'])); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Agama</div>
                <div class="info-value">: <?php echo htmlspecialchars($reg['religion']); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">NISN</div>
                <div class="info-value">: <?php echo htmlspecialchars($reg['nisn'] ?? '-'); ?></div>
            </div>
        </div>
        
        <!-- Alamat -->
        <div class="section">
            <div class="section-title">ALAMAT</div>
            <div class="info-row">
                <div class="info-label">Alamat</div>
                <div class="info-value">: <?php echo htmlspecialchars($reg['address']); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Kota/Kabupaten</div>
                <div class="info-value">: <?php echo htmlspecialchars($reg['city']); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Provinsi</div>
                <div class="info-value">: <?php echo htmlspecialchars($reg['province']); ?></div>
            </div>
        </div>
        
        <!-- Sekolah Asal -->
        <div class="section">
            <div class="section-title">SEKOLAH ASAL</div>
            <div class="info-row">
                <div class="info-label">Nama Sekolah</div>
                <div class="info-value">: <?php echo htmlspecialchars($reg['previous_school']); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Tahun Lulus</div>
                <div class="info-value">: <?php echo htmlspecialchars($reg['graduation_year']); ?></div>
            </div>
        </div>
        
        <!-- Pilihan Jurusan -->
        <div class="section">
            <div class="section-title">PILIHAN JURUSAN</div>
            <div class="info-row">
                <div class="info-label">Pilihan 1</div>
                <div class="info-value">: <?php echo htmlspecialchars($reg['major_choice_1']); ?></div>
            </div>
            <?php if ($reg['major_choice_2']): ?>
            <div class="info-row">
                <div class="info-label">Pilihan 2</div>
                <div class="info-value">: <?php echo htmlspecialchars($reg['major_choice_2']); ?></div>
            </div>
            <?php endif; ?>
        </div>
        
        <!-- Footer -->
        <div class="footer">
            <p>Tanggal Pendaftaran: <?php echo date('d F Y', strtotime($reg['created_at'])); ?></p>
            <div class="signature">
                <p>Panitia PPDB</p>
                <div class="signature-line">
                    (&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;)
                </div>
            </div>
        </div>
        
        <div style="margin-top: 30px; padding: 10px; border: 1px solid #ccc; background: #f9f9f9; font-size: 12px;">
            <strong>Catatan:</strong> Kartu ini adalah bukti pendaftaran. Harap dibawa saat verifikasi dokumen.
        </div>
    </div>
</body>
</html>
