<?php
// public/kurikulum.php - Halaman publik untuk menampilkan kurikulum
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/db.php';

$db = get_db();

// Get filter
$tingkat = $_GET['tingkat'] ?? '';
$jurusan = $_GET['jurusan'] ?? '';

// Build query
$sql = "SELECT * FROM kurikulum WHERE status = 'aktif'";
$params = [];

if ($tingkat) {
  $sql .= " AND tingkat = ?";
  $params[] = $tingkat;
}

if ($jurusan) {
  $sql .= " AND jurusan LIKE ?";
  $params[] = "%$jurusan%";
}

$sql .= " ORDER BY urutan ASC, id DESC";

$stmt = $db->prepare($sql);
$stmt->execute($params);
$kurikulums = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get unique tingkat and jurusan for filter
$tingkatList = $db->query("SELECT DISTINCT tingkat FROM kurikulum WHERE status = 'aktif' AND tingkat IS NOT NULL AND tingkat != '' ORDER BY tingkat")->fetchAll(PDO::FETCH_COLUMN);
$jurusanList = $db->query("SELECT DISTINCT jurusan FROM kurikulum WHERE status = 'aktif' AND jurusan IS NOT NULL AND jurusan != '' ORDER BY jurusan")->fetchAll(PDO::FETCH_COLUMN);

require '_header.php';
?>

<style>
.kurikulum-card {
  transition: transform 0.2s, box-shadow 0.2s;
}
.kurikulum-card:hover {
  transform: translateY(-5px);
  box-shadow: 0 8px 16px rgba(0,0,0,0.1);
}
.filter-section {
  background: #f8f9fa;
  padding: 1.5rem;
  border-radius: 0.5rem;
  margin-bottom: 2rem;
}
</style>

<div class="row mb-4">
  <div class="col-12">
    <h2 class="mb-3"><i class="fa fa-book"></i> Kurikulum Sekolah</h2>
    <p class="text-muted">Informasi lengkap tentang kurikulum yang diterapkan di sekolah kami</p>
  </div>
</div>

<!-- Filter Section -->
<div class="filter-section">
  <form method="get" class="row g-3">
    <div class="col-md-4">
      <label class="form-label">Filter Tingkat/Kelas</label>
      <select name="tingkat" class="form-select">
        <option value="">Semua Tingkat</option>
        <?php foreach ($tingkatList as $t): ?>
          <option value="<?php echo e($t); ?>" <?php echo $tingkat === $t ? 'selected' : ''; ?>>
            Kelas <?php echo e($t); ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-4">
      <label class="form-label">Filter Jurusan</label>
      <select name="jurusan" class="form-select">
        <option value="">Semua Jurusan</option>
        <?php foreach ($jurusanList as $j): ?>
          <option value="<?php echo e($j); ?>" <?php echo $jurusan === $j ? 'selected' : ''; ?>>
            <?php echo e($j); ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-4 d-flex align-items-end">
      <button type="submit" class="btn btn-primary me-2">
        <i class="fa fa-filter"></i> Filter
      </button>
      <a href="kurikulum.php" class="btn btn-secondary">
        <i class="fa fa-redo"></i> Reset
      </a>
    </div>
  </form>
</div>

<!-- Kurikulum List -->
<div class="row">
  <?php if (empty($kurikulums)): ?>
    <div class="col-12">
      <div class="alert alert-info">
        <i class="fa fa-info-circle"></i> Belum ada data kurikulum yang tersedia.
      </div>
    </div>
  <?php else: ?>
    <?php foreach ($kurikulums as $k): ?>
      <div class="col-md-6 col-lg-4 mb-4">
        <div class="card kurikulum-card h-100">
          <div class="card-body">
            <div class="d-flex justify-content-between align-items-start mb-3">
              <h5 class="card-title mb-0"><?php echo e($k['judul']); ?></h5>
              <?php if ($k['tingkat']): ?>
                <span class="badge bg-primary">Kelas <?php echo e($k['tingkat']); ?></span>
              <?php endif; ?>
            </div>
            
            <?php if ($k['jurusan']): ?>
              <p class="mb-2">
                <i class="fa fa-graduation-cap text-primary"></i>
                <strong>Jurusan:</strong> <?php echo e($k['jurusan']); ?>
              </p>
            <?php endif; ?>
            
            <?php if ($k['mata_pelajaran']): ?>
              <p class="mb-2">
                <i class="fa fa-book text-success"></i>
                <strong>Mata Pelajaran:</strong><br>
                <small><?php echo e($k['mata_pelajaran']); ?></small>
              </p>
            <?php endif; ?>
            
            <?php if ($k['deskripsi']): ?>
              <p class="text-muted small mb-3">
                <?php echo nl2br(e(mb_substr($k['deskripsi'], 0, 150))); ?>
                <?php echo mb_strlen($k['deskripsi']) > 150 ? '...' : ''; ?>
              </p>
            <?php endif; ?>
            
            <button type="button" class="btn btn-sm btn-outline-primary" 
                    data-bs-toggle="modal" 
                    data-bs-target="#detailModal<?php echo $k['id']; ?>">
              <i class="fa fa-eye"></i> Lihat Detail
            </button>
            
            <?php if ($k['file_dokumen']): ?>
              <a href="<?php echo base_url(); ?>/data/uploads/kurikulum/<?php echo e($k['file_dokumen']); ?>" 
                 class="btn btn-sm btn-success" 
                 target="_blank">
                <i class="fa fa-download"></i> Download
              </a>
            <?php endif; ?>
          </div>
        </div>
      </div>
      
      <!-- Detail Modal -->
      <div class="modal fade" id="detailModal<?php echo $k['id']; ?>" tabindex="-1">
        <div class="modal-dialog modal-lg">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title"><?php echo e($k['judul']); ?></h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
              <div class="row mb-3">
                <div class="col-md-6">
                  <p><strong>Tingkat/Kelas:</strong> <?php echo e($k['tingkat'] ?: '-'); ?></p>
                  <p><strong>Jurusan:</strong> <?php echo e($k['jurusan'] ?: '-'); ?></p>
                </div>
                <div class="col-md-6">
                  <p><strong>Mata Pelajaran:</strong><br><?php echo e($k['mata_pelajaran'] ?: '-'); ?></p>
                </div>
              </div>
              
              <?php if ($k['deskripsi']): ?>
                <div class="mb-3">
                  <h6>Deskripsi:</h6>
                  <p><?php echo nl2br(e($k['deskripsi'])); ?></p>
                </div>
              <?php endif; ?>
              
              <?php if ($k['kompetensi_dasar']): ?>
                <div class="mb-3">
                  <h6>Kompetensi Dasar:</h6>
                  <p><?php echo nl2br(e($k['kompetensi_dasar'])); ?></p>
                </div>
              <?php endif; ?>
              
              <?php if ($k['materi_pokok']): ?>
                <div class="mb-3">
                  <h6>Materi Pokok:</h6>
                  <p><?php echo nl2br(e($k['materi_pokok'])); ?></p>
                </div>
              <?php endif; ?>
              
              <?php if ($k['file_dokumen']): ?>
                <div class="alert alert-info">
                  <i class="fa fa-file-pdf"></i> 
                  <strong>Dokumen tersedia:</strong> 
                  <a href="<?php echo base_url(); ?>/data/uploads/kurikulum/<?php echo e($k['file_dokumen']); ?>" 
                     target="_blank" class="alert-link">
                    Download Dokumen
                  </a>
                </div>
              <?php endif; ?>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</div>

<?php require '_footer.php'; ?>
