<?php
// public/berita_detail.php - Detail Berita (News)
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

$db = get_db();
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$stmt = $db->prepare("SELECT * FROM berita WHERE id=?");
$stmt->execute([$id]);
$berita = $stmt->fetch(PDO::FETCH_ASSOC);

include '_header.php';
?>
<div class="container py-4">
  <?php if ($berita): ?>
  <h1 class="mb-2"><?php echo e($berita['title']); ?></h1>
  <div class="mb-1"><span class="badge bg-info text-dark">Kategori: <?php echo e($berita['kategori'] ?? '-'); ?></span></div>
  <div class="text-muted mb-3">Diposting <?php echo e($berita['date']); ?> oleh <?php echo e($berita['author']); ?></div>
    <?php if ($berita['image']): ?>
      <img src="../data/uploads/<?php echo e($berita['image']); ?>" alt="Gambar Berita" class="img-fluid mb-3" style="max-height:320px;object-fit:cover;">
    <?php endif; ?>
    <div class="mb-4" style="white-space:pre-line;font-size:1.1em;">
      <?php echo nl2br(e($berita['content'])); ?>
    </div>
    <a href="berita.php" class="btn btn-outline-secondary">&laquo; Kembali ke Berita</a>
  <?php else: ?>
    <div class="alert alert-warning">Berita tidak ditemukan.</div>
    <a href="berita.php" class="btn btn-outline-secondary">&laquo; Kembali ke Berita</a>
  <?php endif; ?>
</div>
<?php include '_footer.php'; ?>
