<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_login();
$db = get_db();

// ensure settings table exists
$db->exec("CREATE TABLE IF NOT EXISTS settings (
  key TEXT PRIMARY KEY,
  value TEXT
)");

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $site_name = trim($_POST['site_name'] ?? '');
    $site_description = trim($_POST['site_description'] ?? '');
    $site_address = trim($_POST['site_address'] ?? '');
    $site_phone = trim($_POST['site_phone'] ?? '');
    $site_email = trim($_POST['site_email'] ?? '');
    
    $logo_file = '';
    
    // Handle logo upload
    if (isset($_FILES['site_logo']) && $_FILES['site_logo']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = __DIR__ . '/../data/uploads/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }
        
        $allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
        $fileType = $_FILES['site_logo']['type'];
        
        if (in_array($fileType, $allowedTypes)) {
            $extension = pathinfo($_FILES['site_logo']['name'], PATHINFO_EXTENSION);
            $fileName = 'logo_' . time() . '.' . $extension;
            $uploadFile = $uploadDir . $fileName;
            
            if (move_uploaded_file($_FILES['site_logo']['tmp_name'], $uploadFile)) {
                $logo_file = $fileName;
                
                // Delete old logo
                $stmt = $db->prepare('SELECT value FROM settings WHERE key = :k');
                $stmt->execute([':k'=>'site_logo']);
                $oldLogo = $stmt->fetchColumn();
                if ($oldLogo && file_exists($uploadDir . $oldLogo)) {
                    unlink($uploadDir . $oldLogo);
                }
            } else {
                $error = 'Gagal mengupload logo';
            }
        } else {
            $error = 'Format file tidak didukung. Gunakan JPG, PNG, GIF, atau WebP';
        }
    }
    
    if (!$error) {
        try {
            $stmt = $db->prepare('INSERT OR REPLACE INTO settings (key,value) VALUES (:k,:v)');
            $stmt->execute([':k'=>'site_name', ':v'=>$site_name]);
            $stmt->execute([':k'=>'site_description', ':v'=>$site_description]);
            $stmt->execute([':k'=>'site_address', ':v'=>$site_address]);
            $stmt->execute([':k'=>'site_phone', ':v'=>$site_phone]);
            $stmt->execute([':k'=>'site_email', ':v'=>$site_email]);
            
            if ($logo_file) {
                $stmt->execute([':k'=>'site_logo', ':v'=>$logo_file]);
            }
            
            $message = 'Pengaturan berhasil disimpan!';
        } catch (Exception $e) {
            $error = 'Gagal menyimpan: ' . $e->getMessage();
        }
    }
}

// Load current settings
$stmt = $db->prepare('SELECT value FROM settings WHERE key = :k');
$stmt->execute([':k'=>'site_name']);
$site_name = $stmt->fetchColumn() ?: 'Sekolah Kita';

$stmt->execute([':k'=>'site_description']);
$site_description = $stmt->fetchColumn() ?: '';

$stmt->execute([':k'=>'site_address']);
$site_address = $stmt->fetchColumn() ?: '';

$stmt->execute([':k'=>'site_phone']);
$site_phone = $stmt->fetchColumn() ?: '';

$stmt->execute([':k'=>'site_email']);
$site_email = $stmt->fetchColumn() ?: '';

$stmt->execute([':k'=>'site_logo']);
$site_logo = $stmt->fetchColumn() ?: '';

require __DIR__ . '/_header.php';
?>

<div class="row">
  <div class="col-12">
    <?php if ($message): ?>
      <div class="alert alert-success alert-dismissible fade show">
        <?php echo e($message); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      </div>
    <?php endif; ?>
    <?php if ($error): ?>
      <div class="alert alert-danger alert-dismissible fade show">
        <?php echo e($error); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      </div>
    <?php endif; ?>
  </div>
</div>

<div class="row">
  <div class="col-md-8">
    <div class="card">
      <div class="card-header">
        <h5 class="card-title mb-0">Pengaturan Situs</h5>
      </div>
      <div class="card-body">
        <form method="post" enctype="multipart/form-data">
          <div class="mb-3">
            <label class="form-label">Nama Sekolah <span class="text-danger">*</span></label>
            <input type="text" name="site_name" value="<?php echo e($site_name); ?>" class="form-control" required>
          </div>
          
          <div class="mb-3">
            <label class="form-label">Deskripsi Sekolah</label>
            <textarea name="site_description" class="form-control" rows="3"><?php echo e($site_description); ?></textarea>
            <small class="text-muted">Deskripsi singkat tentang sekolah</small>
          </div>
          
          <div class="mb-3">
            <label class="form-label">Alamat</label>
            <textarea name="site_address" class="form-control" rows="2"><?php echo e($site_address); ?></textarea>
          </div>
          
          <div class="row">
            <div class="col-md-6 mb-3">
              <label class="form-label">Telepon</label>
              <input type="text" name="site_phone" value="<?php echo e($site_phone); ?>" class="form-control" placeholder="(021) 1234567">
            </div>
            <div class="col-md-6 mb-3">
              <label class="form-label">Email</label>
              <input type="email" name="site_email" value="<?php echo e($site_email); ?>" class="form-control" placeholder="info@sekolah.sch.id">
            </div>
          </div>
          
          <div class="mb-3">
            <label class="form-label">Logo Sekolah</label>
            <input type="file" name="site_logo" class="form-control" accept="image/jpeg,image/png,image/gif,image/webp">
            <small class="text-muted">Format: JPG, PNG, GIF, WebP. Maksimal 2MB. Rekomendasi ukuran: 200x200px</small>
          </div>
          
          <div class="d-grid">
            <button type="submit" class="btn btn-primary">
              <i class="fa fa-save"></i> Simpan Pengaturan
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>
  
  <div class="col-md-4">
    <div class="card">
      <div class="card-header">
        <h5 class="card-title mb-0">Preview Logo</h5>
      </div>
      <div class="card-body text-center">
        <?php if ($site_logo): ?>
          <img src="<?php echo base_url(); ?>/data/uploads/<?php echo e($site_logo); ?>" 
               alt="Logo Sekolah" 
               class="img-fluid rounded shadow-sm mb-3" 
               style="max-width: 200px;">
          <p class="text-muted small mb-0">Logo saat ini</p>
        <?php else: ?>
          <div class="text-muted py-5">
            <i class="fa fa-image fa-3x mb-3"></i>
            <p>Belum ada logo</p>
          </div>
        <?php endif; ?>
      </div>
    </div>
    
    <div class="card mt-3">
      <div class="card-header">
        <h5 class="card-title mb-0">Informasi</h5>
      </div>
      <div class="card-body">
        <p class="small mb-2"><i class="fa fa-info-circle text-primary"></i> <strong>Tips Upload Logo:</strong></p>
        <ul class="small mb-0">
          <li>Gunakan gambar dengan latar belakang transparan (PNG)</li>
          <li>Ukuran ideal: 200x200px atau 400x400px</li>
          <li>Logo akan ditampilkan di header website</li>
          <li>Pastikan logo terlihat jelas dan profesional</li>
        </ul>
      </div>
    </div>
  </div>
</div>

<?php
require __DIR__ . '/_footer.php';
?>