<?php
// admin/sambutan.php - CRUD Sambutan Kepala Sekolah
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

$db = get_db();
// Table for sambutan (single row)
$db->exec("CREATE TABLE IF NOT EXISTS sambutan (
    id INTEGER PRIMARY KEY CHECK (id = 1),
    nama TEXT,
    jabatan TEXT,
    foto TEXT,
    isi TEXT
)");
$row = $db->query("SELECT * FROM sambutan WHERE id=1")->fetch(PDO::FETCH_ASSOC);
if (!$row) {
    $db->exec("INSERT INTO sambutan (id, nama, jabatan, foto, isi) VALUES (1, '', '', '', '')");
    $row = ['nama'=>'', 'jabatan'=>'', 'foto'=>'', 'isi'=>''];
}
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nama = trim($_POST['nama'] ?? '');
    $jabatan = trim($_POST['jabatan'] ?? 'Kepala Sekolah');
    $isi = trim($_POST['isi'] ?? '');
    $foto = $_POST['old_foto'] ?? '';
    if (!empty($_FILES['foto']['name'])) {
        $imgName = time() . '_' . preg_replace('/[^a-zA-Z0-9._-]/', '', $_FILES['foto']['name']);
        $dest = __DIR__ . '/../data/uploads/' . $imgName;
        if (move_uploaded_file($_FILES['foto']['tmp_name'], $dest)) {
            $foto = $imgName;
        }
    }
    $stmt = $db->prepare("UPDATE sambutan SET nama=?, jabatan=?, foto=?, isi=? WHERE id=1");
    $stmt->execute([$nama, $jabatan, $foto, $isi]);
    header('Location: sambutan.php?msg=saved'); exit;
}
include '_header.php';
?>
<div class="container-fluid">
  <h1 class="mt-3 mb-4">Sambutan Kepala Sekolah</h1>
  <?php if (!empty($_GET['msg'])): ?><div class="alert alert-success">Data berhasil disimpan.</div><?php endif; ?>
  <form method="post" enctype="multipart/form-data" class="card p-3 mb-4">
    <div class="mb-3">
      <label class="form-label">Nama Kepala Sekolah</label>
      <input type="text" name="nama" class="form-control" value="<?php echo e($row['nama']); ?>" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Jabatan</label>
      <input type="text" name="jabatan" class="form-control" value="<?php echo e($row['jabatan'] ?? 'Kepala Sekolah'); ?>">
    </div>
    <div class="mb-3">
      <label class="form-label">Foto (opsional)</label>
      <input type="file" name="foto" class="form-control">
      <?php if (!empty($row['foto'])): ?>
        <img src="../data/uploads/<?php echo e($row['foto']); ?>" alt="Foto" class="img-thumbnail mt-2" style="max-width:120px;">
        <input type="hidden" name="old_foto" value="<?php echo e($row['foto']); ?>">
      <?php endif; ?>
    </div>
    <div class="mb-3">
      <label class="form-label">Isi Sambutan</label>
      <textarea name="isi" class="form-control tinymce" rows="6"><?php echo e($row['isi']); ?></textarea>
    </div>
    <button type="submit" class="btn btn-primary">Simpan</button>
  </form>
  <script src="https://cdn.jsdelivr.net/npm/tinymce@6.8.3/tinymce.min.js"></script>
  <script>
tinymce.init({ selector: 'textarea.tinymce', height: 220, menubar: false, plugins: 'lists link', toolbar: 'undo redo | bold italic underline | bullist numlist | link', branding: false });
</script>
</div>
<?php include '_footer.php'; ?>
