<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/functions.php';

// logout handler before any output
if (isset($_GET['logout'])) {
    logout();
    header('Location: login.php');
    exit;
}

require_login();

// prepare DB stats for dashboard
require_once __DIR__ . '/../includes/db.php';
$db = get_db();
try {
    $total_students = (int) $db->query('SELECT COUNT(*) FROM students')->fetchColumn();
} catch (Exception $e) { $total_students = 0; }
try {
    $total_admins = (int) $db->query('SELECT COUNT(*) FROM admins')->fetchColumn();
} catch (Exception $e) { $total_admins = 0; }
try {
    $students_with_photo = (int) $db->query("SELECT COUNT(*) FROM students WHERE photo IS NOT NULL AND photo != ''")->fetchColumn();
} catch (Exception $e) { $students_with_photo = 0; }
try {
    $distinct_grades = (int) $db->query("SELECT COUNT(DISTINCT grade) FROM students WHERE grade IS NOT NULL AND grade != ''")->fetchColumn();
} catch (Exception $e) { $distinct_grades = 0; }

// recent students
try {
    $stmt = $db->prepare('SELECT id, nis, name, grade, photo, created_at FROM students ORDER BY created_at DESC LIMIT 6');
    $stmt->execute();
    $recent_students = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) { $recent_students = []; }

// render header + sidebar
require __DIR__ . '/_header.php';
?>

            <!-- begin dashboard content (adapted from AdminLTE v4 demo) -->
            <div class="row">
                <div class="col-lg-3 col-6">
                    <div class="small-box text-bg-primary">
                        <div class="inner">
                            <h3><?php echo e($total_students); ?></h3>
                            <p>Total Siswa</p>
                        </div>
                        <a href="students.php" class="small-box-footer link-light">Kelola Siswa <i class="fa fa-link"></i></a>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box text-bg-success">
                        <div class="inner"><h3><?php echo e($total_admins); ?></h3><p>Total Admin</p></div>
                        <a href="users.php" class="small-box-footer link-light">Kelola Users <i class="fa fa-link"></i></a>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box text-bg-warning">
                        <div class="inner"><h3><?php echo e($students_with_photo); ?></h3><p>Dengan Foto</p></div>
                        <a href="students.php" class="small-box-footer link-dark">Lihat Foto <i class="fa fa-link"></i></a>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box text-bg-danger">
                        <div class="inner"><h3><?php echo e($distinct_grades); ?></h3><p>Jumlah Kelas</p></div>
                        <a href="students.php" class="small-box-footer link-light">Detail Kelas <i class="fa fa-link"></i></a>
                    </div>
                </div>
            </div>

            <!-- removed demo Sales and Direct Chat cards to keep dashboard focused on stats and recent students -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header"><h3 class="card-title">Siswa Terbaru</h3></div>
                        <div class="card-body p-0">
                            <table class="table table-striped mb-0">
                                <thead><tr><th>#</th><th>NIS</th><th>Nama</th><th>Kelas</th><th>Foto</th><th>Terdaftar</th></tr></thead>
                                <tbody>
                                <?php if (count($recent_students) === 0): ?>
                                    <tr><td colspan="6" class="text-center">Belum ada data siswa</td></tr>
                                <?php else: ?>
                                    <?php foreach ($recent_students as $i => $s): ?>
                                        <tr>
                                            <td><?php echo e($i+1); ?></td>
                                            <td><?php echo e($s['nis']); ?></td>
                                            <td><?php echo e($s['name']); ?></td>
                                            <td><?php echo e($s['grade']); ?></td>
                                            <td>
                                                <?php if (!empty($s['photo'])): ?>
                                                    <img src="<?php echo e(base_url()); ?>/data/uploads/<?php echo e(basename($s['photo'])); ?>" alt="foto" style="height:36px;width:36px;border-radius:4px;" />
                                                <?php else: ?>
                                                    -
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($s['created_at']); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

<?php
// render footer which closes content and includes scripts
require __DIR__ . '/_footer.php';
?>