<?php
// admin/_header.php - shared header + sidebar for admin pages
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/../includes/functions.php';
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin - Website Sekolah</title>
  <link rel="stylesheet" href="<?php echo base_url(); ?>/assets/vendor/fontawesome/css/all.min.css">
  <!-- AdminLTE v4 expects Bootstrap 5 -->
  <link rel="stylesheet" href="<?php echo base_url(); ?>/assets/vendor/bootstrap5/css/bootstrap.min.css">
  <!-- use local AdminLTE CSS from assets folder -->
  <link rel="stylesheet" href="<?php echo base_url(); ?>/assets/dist/css/adminlte.min.css">
  <style>
    /* Ensure submenu is visible when menu-open class is present */
    .nav-item.menu-open > .nav-treeview {
      display: block !important;
      max-height: 1000px;
      opacity: 1;
      transition: max-height 0.3s ease, opacity 0.3s ease;
    }
    .nav-treeview {
      display: none;
      max-height: 0;
      opacity: 0;
      overflow: hidden;
      transition: max-height 0.3s ease, opacity 0.3s ease;
    }
    /* Fix icon alignment */
    .nav-icon {
      margin-right: 0.5rem;
    }
    /* Make sure parent nav-item has pointer cursor */
    .nav-item > .nav-link {
      cursor: pointer;
    }
    
    /* Desktop optimizations */
    @media (min-width: 992px) {
      /* Smooth transitions for sidebar */
      .app-sidebar {
        transition: margin-left 0.3s ease-in-out, width 0.3s ease-in-out;
      }
      
      /* Better spacing for sidebar items */
      .sidebar-menu .nav-item {
        margin-bottom: 0.25rem;
      }
      
      .sidebar-menu .nav-link {
        padding: 0.75rem 1rem;
        border-radius: 0.25rem;
        transition: all 0.2s ease;
      }
      
      .sidebar-menu .nav-link:hover {
        background-color: rgba(255, 255, 255, 0.1);
      }
      
      .sidebar-menu .nav-link.active {
        background-color: rgba(255, 255, 255, 0.15);
        font-weight: 500;
      }
      
      /* Submenu styling */
      .nav-treeview {
        padding-left: 0;
        margin-top: 0.25rem;
      }
      
      .nav-treeview .nav-item {
        margin-bottom: 0;
      }
      
      .nav-treeview .nav-link {
        padding: 0.5rem 1rem 0.5rem 2.5rem;
        font-size: 0.9rem;
      }
      
      .nav-treeview .nav-link:hover {
        background-color: rgba(255, 255, 255, 0.08);
      }
      
      .nav-treeview .nav-link.active {
        background-color: rgba(255, 255, 255, 0.12);
      }
      
      /* Arrow animation */
      .nav-arrow {
        transition: transform 0.2s ease;
        float: right;
        margin-top: 0.25rem;
      }
      
      .nav-item.menu-open > .nav-link .nav-arrow {
        transform: rotate(90deg);
      }
      
      /* Sidebar brand styling */
      .sidebar-brand .brand-link {
        padding: 1rem;
        display: block;
        text-align: center;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
      }
      
      .sidebar-brand .brand-text {
        font-size: 1.25rem;
        font-weight: 300;
      }
      
      /* Content area padding */
      .app-content {
        padding: 1.5rem 0;
      }
      
      /* Header improvements */
      .app-header {
        box-shadow: 0 2px 4px rgba(0,0,0,0.08);
      }
      
      /* Scrollbar styling for sidebar */
      .sidebar-wrapper::-webkit-scrollbar {
        width: 6px;
      }
      
      .sidebar-wrapper::-webkit-scrollbar-track {
        background: rgba(255, 255, 255, 0.05);
      }
      
      .sidebar-wrapper::-webkit-scrollbar-thumb {
        background: rgba(255, 255, 255, 0.2);
        border-radius: 3px;
      }
      
      .sidebar-wrapper::-webkit-scrollbar-thumb:hover {
        background: rgba(255, 255, 255, 0.3);
      }
    }
    
    /* Mobile optimizations */
    @media (max-width: 991px) {
      .sidebar-menu .nav-link {
        padding: 0.65rem 1rem;
      }
      
      .nav-treeview .nav-link {
        padding: 0.5rem 1rem 0.5rem 2rem;
      }
      
      /* Mobile sidebar overlay */
      body:not(.sidebar-collapse) .app-sidebar {
        transform: translateX(0);
      }
      
      body.sidebar-collapse .app-sidebar {
        transform: translateX(-100%);
      }
    }
    
    /* Sidebar collapse behavior */
    .sidebar-collapse .app-sidebar {
      margin-left: -250px;
    }
    
    .sidebar-collapse .app-main {
      margin-left: 0 !important;
    }
    
    /* Smooth transition for sidebar */
    .app-sidebar,
    .app-main {
      transition: all 0.3s ease-in-out;
    }
    
    /* Hide text when sidebar is collapsed on desktop */
    @media (min-width: 992px) {
      .sidebar-collapse .app-sidebar .brand-text,
      .sidebar-collapse .app-sidebar .nav-link p,
      .sidebar-collapse .app-sidebar .nav-arrow {
        display: none;
      }
      
      .sidebar-collapse .app-sidebar {
        width: 4.6rem;
        margin-left: 0;
      }
      
      .sidebar-collapse .app-main {
        margin-left: 4.6rem !important;
      }
      
      .sidebar-collapse .sidebar-menu .nav-link {
        text-align: center;
        padding: 0.75rem 0;
      }
      
      .sidebar-collapse .nav-icon {
        margin-right: 0;
        font-size: 1.2rem;
      }
      
      .sidebar-collapse .nav-treeview {
        display: none !important;
      }
      
      /* Tooltip for collapsed sidebar */
      .sidebar-collapse .sidebar-menu .nav-link {
        position: relative;
      }
      
      .sidebar-collapse .sidebar-menu .nav-link:hover::after {
        content: attr(title);
        position: absolute;
        left: 100%;
        top: 50%;
        transform: translateY(-50%);
        background: rgba(0, 0, 0, 0.8);
        color: white;
        padding: 0.5rem 0.75rem;
        border-radius: 0.25rem;
        white-space: nowrap;
        margin-left: 0.5rem;
        font-size: 0.875rem;
        z-index: 1000;
        pointer-events: none;
      }
    }
  </style>
</head>
<body class="layout-fixed sidebar-expand-lg sidebar-open bg-body-tertiary">

<script>
  // apply saved sidebar collapsed state as early as possible to avoid layout flash
  (function(){
    try {
      if (localStorage.getItem('adminSidebarCollapsed') === '1') {
        document.documentElement.classList.add('sidebar-collapse');
        document.body.classList.add('sidebar-collapse');
      }
    } catch(e){}
  })();
</script>

<!-- App wrapper for AdminLTE v4 -->
<div class="app-wrapper">

  <!-- Header -->
  <nav class="app-header navbar navbar-expand bg-body">
    <div class="container-fluid">
      <ul class="navbar-nav">
        <li class="nav-item">
          <a class="nav-link" data-lte-toggle="sidebar" href="#" role="button" title="Toggle Sidebar"><i class="fa fa-bars"></i></a>
        </li>
        <li class="nav-item d-none d-md-block"><a href="dashboard.php" class="nav-link"><?php echo e('Dashboard'); ?></a></li>
        <li class="nav-item d-none d-lg-block"><a href="../public/index.php" class="nav-link" target="_blank"><i class="fa fa-globe me-1"></i>Lihat Website</a></li>
      </ul>
      <ul class="navbar-nav ms-auto">
        <li class="nav-item d-none d-md-block">
          <span class="nav-link text-muted"><i class="fa fa-user-circle me-1"></i><?php echo e($_SESSION['username'] ?? 'Admin'); ?></span>
        </li>
        <li class="nav-item">
          <a href="?logout=1" class="nav-link" title="Logout"><i class="fa fa-sign-out-alt"></i><span class="d-none d-md-inline ms-1">Logout</span></a>
        </li>
      </ul>
    </div>
  </nav>

  <!-- Sidebar -->
  <aside class="app-sidebar bg-body-secondary shadow" data-bs-theme="dark">
    <div class="sidebar-brand">
      <a href="dashboard.php" class="brand-link">
        <span class="brand-text fw-light"><?php echo e(get_setting('site_name','Sekolah Kita')); ?></span>
      </a>
    </div>
    <div class="sidebar-wrapper">
      <nav class="mt-2">
        <ul class="nav sidebar-menu flex-column" data-lte-toggle="treeview" role="navigation" aria-label="Main navigation" data-accordion="false" id="navigation">
          <li class="nav-item">
            <a href="dashboard.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'dashboard.php' ? 'active' : ''; ?>" title="Dashboard">
              <i class="nav-icon fa fa-tachometer-alt"></i>
              <p>Dashboard</p>
            </a>
          </li>
          <?php
          $masterDataPages = ['students.php','users.php','guru.php','slides.php','berita.php','download.php','menu.php','visimisi.php','sambutan.php','kontak.php','kurikulum.php','homepage.php','media.php'];
          $isMasterDataActive = in_array(basename($_SERVER['PHP_SELF']), $masterDataPages);
          ?>
          <li class="nav-item <?php echo $isMasterDataActive ? 'menu-open' : ''; ?>">
            <a href="#" class="nav-link <?php echo $isMasterDataActive ? 'active' : ''; ?>" title="Master Data">
              <i class="nav-icon fa fa-database"></i>
              <p>Master Data <i class="nav-arrow fa fa-chevron-right"></i></p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item"><a href="students.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'students.php' ? 'active' : ''; ?>" title="Data Siswa"><i class="nav-icon fa fa-circle"></i><p>Siswa</p></a></li>
              <li class="nav-item"><a href="users.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'users.php' ? 'active' : ''; ?>" title="Data Users"><i class="nav-icon fa fa-circle"></i><p>Users</p></a></li>
              <li class="nav-item"><a href="guru.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'guru.php' ? 'active' : ''; ?>" title="Data Guru"><i class="nav-icon fa fa-chalkboard-teacher"></i><p>Guru</p></a></li>
              <li class="nav-item"><a href="slides.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'slides.php' ? 'active' : ''; ?>" title="Slides Banner"><i class="nav-icon fa fa-image"></i><p>Slides</p></a></li>
              <li class="nav-item"><a href="berita.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'berita.php' ? 'active' : ''; ?>" title="Berita"><i class="nav-icon fa fa-newspaper"></i><p>Berita</p></a></li>
              <li class="nav-item"><a href="download.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'download.php' ? 'active' : ''; ?>" title="File Download"><i class="nav-icon fa fa-download"></i><p>Download</p></a></li>
              <li class="nav-item"><a href="menu.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'menu.php' ? 'active' : ''; ?>" title="Menu Publik"><i class="nav-icon fa fa-bars"></i><p>Menu Publik</p></a></li>
              <li class="nav-item"><a href="visimisi.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'visimisi.php' ? 'active' : ''; ?>" title="Visi & Misi"><i class="nav-icon fa fa-bullseye"></i><p>Visi Misi</p></a></li>
              <li class="nav-item"><a href="sambutan.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'sambutan.php' ? 'active' : ''; ?>" title="Sambutan Kepala Sekolah"><i class="nav-icon fa fa-user-tie"></i><p>Sambutan</p></a></li>
              <li class="nav-item"><a href="kontak.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'kontak.php' ? 'active' : ''; ?>" title="Informasi Kontak"><i class="nav-icon fa fa-address-book"></i><p>Kontak</p></a></li>
              <li class="nav-item"><a href="kurikulum.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'kurikulum.php' ? 'active' : ''; ?>" title="Kurikulum"><i class="nav-icon fa fa-book"></i><p>Kurikulum</p></a></li>
              <li class="nav-item"><a href="media.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'media.php' ? 'active' : ''; ?>" title="Galeri Media"><i class="nav-icon fa fa-images"></i><p>Media (Galeri)</p></a></li>
              <li class="nav-item"><a href="homepage.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'homepage.php' ? 'active' : ''; ?>" title="Homepage Content"><i class="nav-icon fa fa-home"></i><p>Homepage</p></a></li>
            </ul>
          </li>

          <li class="nav-item"><a href="settings.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'settings.php' ? 'active' : ''; ?>" title="Pengaturan"><i class="nav-icon fa fa-cog"></i><p>Pengaturan</p></a></li>
          <li class="nav-item"><a href="database_backup.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'database_backup.php' ? 'active' : ''; ?>" title="Backup & Restore Database"><i class="nav-icon fa fa-database"></i><p>Backup Database</p></a></li>
          <li class="nav-item"><a href="../public/index.php" class="nav-link" target="_blank" title="Lihat Website Publik"><i class="nav-icon fa fa-globe"></i><p>Site Publik</p></a></li>
        </ul>
      </nav>
    </div>
  </aside>

  <!-- Main content area -->
  <main class="app-main">
    <div class="app-content-header">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-6">
            <h3 class="mb-0">
              <?php
              $currentPage = basename($_SERVER['PHP_SELF'], '.php');
              $pageTitle = ucfirst(str_replace('_', ' ', $currentPage));
              // Custom titles
              $titles = [
                'dashboard' => 'Dashboard',
                'students' => 'Data Siswa',
                'users' => 'Data Users',
                'guru' => 'Data Guru',
                'slides' => 'Slides Banner',
                'berita' => 'Berita',
                'download' => 'File Download',
                'menu' => 'Menu Publik',
                'visimisi' => 'Visi & Misi',
                'sambutan' => 'Sambutan Kepala Sekolah',
                'kontak' => 'Informasi Kontak',
                'kurikulum' => 'Kurikulum',
                'homepage' => 'Konten Homepage',
                'settings' => 'Pengaturan'
              ];
              echo e($titles[$currentPage] ?? $pageTitle);
              ?>
            </h3>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-end">
              <li class="breadcrumb-item"><a href="dashboard.php"><i class="fa fa-home"></i> Home</a></li>
              <?php if ($currentPage !== 'dashboard'): ?>
              <li class="breadcrumb-item active" aria-current="page"><?php echo e($titles[$currentPage] ?? $pageTitle); ?></li>
              <?php endif; ?>
            </ol>
          </div>
        </div>
      </div>
    </div>
    <div class="app-content">
      <div class="container-fluid">
