# Modul PPDB (Penerimaan Peserta Didik Baru)

## 📋 Deskripsi
Modul lengkap untuk mengelola pendaftaran peserta didik baru dengan sistem role-based access control.

## 👥 Role & Hak Akses

### 1. **Admin**
- Mengelola pengaturan PPDB (buka/tutup pendaftaran, kuota, dll)
- Melihat semua pendaftaran
- Verifikasi dan approval pendaftaran
- Mengubah status pendaftaran (pending, verified, accepted, rejected)
- Melihat laporan dan statistik
- Mengelola user operator

### 2. **Operator**
- Melihat daftar pendaftaran
- Verifikasi dokumen pendaftaran
- Mengubah status pendaftaran
- Mencetak kartu pendaftaran
- Melihat laporan

### 3. **Siswa/Calon Siswa**
- Mendaftar sebagai calon siswa baru
- Mengisi formulir pendaftaran
- Upload dokumen
- Cek status pendaftaran
- Cetak kartu pendaftaran (jika diterima)

## 📁 Struktur File

```
/public/
  ├── ppdb_register.php      # Form pendaftaran untuk calon siswa
  ├── ppdb_check.php          # Cek status pendaftaran
  └── ppdb_print.php          # Cetak kartu pendaftaran

/admin/
  ├── ppdb_dashboard.php      # Dashboard PPDB (Admin/Operator)
  ├── ppdb_list.php           # Daftar pendaftaran
  ├── ppdb_detail.php         # Detail pendaftaran
  ├── ppdb_settings.php       # Pengaturan PPDB (Admin only)
  └── ppdb_reports.php        # Laporan dan statistik

/data/uploads/ppdb/           # Folder untuk upload dokumen
```

## 🗄️ Database Tables

### 1. `ppdb_registrations`
Menyimpan data pendaftaran siswa baru dengan field:
- Data pribadi (nama, TTL, jenis kelamin, agama, dll)
- Alamat lengkap
- Data orang tua/wali
- Sekolah asal
- Pilihan jurusan
- Dokumen (foto, ijazah, dll)
- Status pendaftaran

### 2. `ppdb_settings`
Pengaturan PPDB:
- Status buka/tutup
- Tanggal pendaftaran
- Kuota
- Tahun ajaran
- Biaya pendaftaran

### 3. `ppdb_logs`
Log aktivitas untuk audit trail

## 🚀 Instalasi

### 1. Import Database
```bash
mysql -u root -p nama_database < database_ppdb.sql
```

### 2. Buat Folder Upload
```bash
mkdir -p data/uploads/ppdb
chmod 755 data/uploads/ppdb
```

### 3. Update Role User
Pastikan tabel `users` memiliki kolom `role`:
```sql
ALTER TABLE users ADD COLUMN role ENUM('admin', 'operator', 'student', 'teacher') DEFAULT 'student';
UPDATE users SET role = 'admin' WHERE id = 1;
```

## 📝 Cara Penggunaan

### Untuk Calon Siswa:
1. Buka halaman: `http://localhost/mygb/public/ppdb_register.php`
2. Isi formulir pendaftaran
3. Upload dokumen yang diperlukan
4. Submit dan simpan nomor pendaftaran
5. Cek status di: `http://localhost/mygb/public/ppdb_check.php`

### Untuk Admin/Operator:
1. Login ke admin panel
2. Akses menu PPDB
3. Kelola pendaftaran masuk
4. Verifikasi dokumen
5. Ubah status pendaftaran
6. Cetak laporan

## 🔐 Keamanan

- ✅ Role-based access control
- ✅ Input validation
- ✅ SQL injection prevention (PDO prepared statements)
- ✅ File upload validation
- ✅ Audit trail (logging)
- ✅ Session management

## 📊 Fitur Utama

### ✨ Pendaftaran Online
- Form pendaftaran lengkap
- Upload dokumen
- Validasi data
- Nomor pendaftaran otomatis

### 📋 Manajemen Pendaftaran
- Daftar pendaftaran dengan filter
- Pencarian berdasarkan nama/nomor
- Pagination
- Export data

### ✅ Verifikasi
- Verifikasi dokumen
- Approval/rejection
- Catatan verifikasi
- Notifikasi status

### 📈 Laporan
- Statistik pendaftaran
- Laporan per jurusan
- Grafik perkembangan
- Export PDF/Excel

## 🎨 Status Pendaftaran

| Status | Deskripsi | Warna |
|--------|-----------|-------|
| `pending` | Menunggu verifikasi | Warning (Kuning) |
| `verified` | Sudah diverifikasi | Info (Biru) |
| `accepted` | Diterima | Success (Hijau) |
| `rejected` | Ditolak | Danger (Merah) |

## 🔧 Konfigurasi

Edit pengaturan di admin panel atau langsung di database:

```sql
UPDATE ppdb_settings SET setting_value = '1' WHERE setting_key = 'ppdb_open';
UPDATE ppdb_settings SET setting_value = '2024/2025' WHERE setting_key = 'ppdb_year';
UPDATE ppdb_settings SET setting_value = '100' WHERE setting_key = 'ppdb_quota';
```

## 📞 Support

Untuk bantuan lebih lanjut, hubungi administrator sistem.

## 📝 Changelog

### Version 1.0.0 (2024)
- Initial release
- Form pendaftaran online
- Dashboard admin/operator
- Sistem verifikasi
- Laporan dasar

## 🚧 Roadmap

- [ ] Notifikasi email otomatis
- [ ] Payment gateway integration
- [ ] SMS notification
- [ ] Mobile app
- [ ] Online test integration
- [ ] Document verification with AI

## 📄 License

Proprietary - For internal use only
