# Troubleshooting Import MySQL di phpMyAdmin

## 🔧 Error yang Sering Terjadi

### Error 1: "A closing bracket was expected (near 'utf8mb4_unicode_ci' at position 112)"

**Penyebab:**
- Syntax CREATE TABLE tidak sesuai dengan MySQL
- Masalah dengan PRIMARY KEY placement
- ENGINE dan CHARSET tidak di format yang benar

**Solusi:**
1. Pastikan Anda memilih format **"MySQL/MariaDB SQL"** saat backup (BUKAN "SQLite SQL")
2. Buat backup baru dengan format yang benar
3. File backup MySQL akan memiliki nama: `backup_YYYY-MM-DD_HH-MM-SS_mysql.sql`

**Cara Cek Format File:**
Buka file SQL dengan text editor, cek baris awal:
```sql
-- MySQL Database Backup (Converted from SQLite)  ✅ BENAR
-- SQLite Database Backup  ❌ SALAH untuk phpMyAdmin
```

---

### Error 2: "You have an error in your SQL syntax"

**Penyebab:**
- File menggunakan syntax SQLite
- Tipe data tidak compatible

**Solusi:**
1. Hapus file backup lama
2. Buat backup baru dengan pilihan **"MySQL/MariaDB SQL"**
3. Pastikan radio button "MySQL/MariaDB SQL" ter-check sebelum klik backup

---

### Error 3: "Unknown column type 'INTEGER'"

**Penyebab:**
- File masih menggunakan tipe data SQLite
- Konversi tidak berjalan

**Solusi:**
File MySQL yang benar harus menggunakan:
- `INT` bukan `INTEGER`
- `DOUBLE` bukan `REAL`
- `AUTO_INCREMENT` bukan `AUTOINCREMENT`

Contoh yang BENAR untuk MySQL:
```sql
CREATE TABLE `students` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `nis` TEXT,
  `name` TEXT NOT NULL,
  `grade` TEXT,
  `photo` TEXT,
  `created_at` TEXT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
```

Contoh yang SALAH (SQLite):
```sql
CREATE TABLE students (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    nis TEXT UNIQUE,
    name TEXT NOT NULL
);
```

---

### Error 4: "The uploaded file exceeds the upload_max_filesize"

**Penyebab:**
- File backup terlalu besar
- Limit upload PHP terlalu kecil

**Solusi A: Increase PHP Limits**
Edit `php.ini`:
```ini
upload_max_filesize = 100M
post_max_size = 100M
max_execution_time = 300
```
Restart Apache/Nginx

**Solusi B: Import via Command Line**
```bash
mysql -u root -p nama_database < backup_file.sql
```

---

### Error 5: "Duplicate entry for key 'PRIMARY'"

**Penyebab:**
- Database sudah ada data
- Import dilakukan 2x

**Solusi:**
1. Drop database lama:
   ```sql
   DROP DATABASE IF EXISTS nama_database;
   CREATE DATABASE nama_database CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
   ```
2. Import ulang ke database kosong

---

## ✅ Checklist Sebelum Import

- [ ] Backup dibuat dengan format **"MySQL/MariaDB SQL"** (ada radio button)
- [ ] File nama mengandung `_mysql.sql` (contoh: `backup_2024-01-15_14-30-45_mysql.sql`)
- [ ] Buka file dengan text editor, cek header: "MySQL Database Backup (Converted from SQLite)"
- [ ] Database target sudah dibuat di phpMyAdmin
- [ ] Database menggunakan charset: `utf8mb4_unicode_ci`
- [ ] File size tidak melebihi `upload_max_filesize`

---

## 🎯 Langkah Import yang Benar

### 1. Buat Backup MySQL Format
1. Login ke Admin Panel
2. Klik "Backup & Restore Database"
3. Di bagian "Backup Format SQL (.sql)"
4. **PILIH** radio button **"MySQL/MariaDB SQL"** ⭐ PENTING!
5. Klik "Backup Format SQL (.sql)"
6. Download file yang dihasilkan

### 2. Verifikasi File Backup
Buka file dengan Notepad/text editor, pastikan ada:
```sql
-- MySQL Database Backup (Converted from SQLite)
-- Generated: 2024-01-15 14:30:45
-- Source Database: school.db
-- Compatible with: MySQL 5.7+, MariaDB 10.2+

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";
```

### 3. Buat Database di phpMyAdmin
```sql
CREATE DATABASE school_backup 
CHARACTER SET utf8mb4 
COLLATE utf8mb4_unicode_ci;
```

### 4. Import File
1. Pilih database `school_backup`
2. Klik tab "Import"
3. Choose file → pilih file backup MySQL
4. Format: SQL
5. Charset: utf-8
6. Klik "Go"

### 5. Verifikasi
- Cek tab "Structure" → harus ada tabel
- Klik nama tabel → cek data
- Pastikan semua data ter-import

---

## 🔍 Cara Membedakan Format File

### Format SQLite SQL (❌ Tidak bisa di phpMyAdmin)
```sql
-- SQLite Database Backup
CREATE TABLE students (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    nis TEXT UNIQUE,
    name TEXT NOT NULL
);
INSERT INTO students VALUES (1, '001', 'John');
```

### Format MySQL SQL (✅ Bisa di phpMyAdmin)
```sql
-- MySQL Database Backup (Converted from SQLite)
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";

CREATE TABLE `students` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `nis` TEXT,
  `name` TEXT NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `students` (`id`, `nis`, `name`) VALUES
(1, '001', 'John');
```

**Perbedaan Utama:**
| SQLite | MySQL |
|--------|-------|
| `INTEGER` | `INT` |
| `AUTOINCREMENT` | `AUTO_INCREMENT` |
| No backticks | Backticks \`table\` |
| No ENGINE | ENGINE=InnoDB |
| No CHARSET | CHARSET=utf8mb4 |
| VALUES (1, 'a') | VALUES\n(1, 'a'); |

---

## 💡 Tips

### Tip 1: Selalu Cek Format
Sebelum upload, buka file dengan text editor dan cek header pertama.

### Tip 2: Gunakan Nama File
File MySQL akan otomatis diberi nama dengan suffix `_mysql.sql`

### Tip 3: Test di Database Baru
Jangan import langsung ke database production. Test dulu di database baru.

### Tip 4: Backup Database MySQL
Setelah import sukses, buat backup dari phpMyAdmin juga untuk jaga-jaga.

### Tip 5: Command Line Lebih Cepat
Untuk file besar, gunakan command line import lebih cepat dan reliable.

---

## 📞 Masih Error?

Jika masih mengalami error setelah mengikuti panduan ini:

1. **Screenshot error message** yang muncul di phpMyAdmin
2. **Buka file backup** dengan text editor, copy 20 baris pertama
3. **Cek versi MySQL**: `SELECT VERSION();` di phpMyAdmin
4. **Cek PHP limits**: Buat file `info.php`:
   ```php
   <?php phpinfo(); ?>
   ```
   Akses via browser, cek `upload_max_filesize` dan `post_max_size`

---

## ✅ Kesimpulan

**PENTING:** Pastikan Anda memilih format **"MySQL/MariaDB SQL"** saat membuat backup!

Jangan gunakan format "SQLite SQL" untuk import ke phpMyAdmin.

File yang benar akan memiliki:
- Nama: `backup_YYYY-MM-DD_HH-MM-SS_mysql.sql`
- Header: "MySQL Database Backup (Converted from SQLite)"
- Syntax: MySQL compatible (INT, AUTO_INCREMENT, ENGINE, CHARSET)

Jika sudah benar tapi masih error, kemungkinan ada masalah dengan:
- Versi MySQL terlalu lama (minimal 5.7)
- PHP limits terlalu kecil
- Permissions database

---

**Good luck! 🚀**
