# MySQL Migration - Quick Start Guide

## 🚀 Quick Migration Steps

### 1. Prerequisites Check
```bash
# Check PHP extensions
php -m | findstr -i "mysqli pdo_sqlite"

# Verify MySQL is running (XAMPP Control Panel)
```

### 2. Configure Database
```bash
# Copy configuration template
copy config\database.php.example config\database.php

# Edit config/database.php with your MySQL credentials
# Keep DB_TYPE='sqlite' for now!
```

### 3. Test Connection
```bash
# Test MySQL connection
php -r "new mysqli('localhost', 'root', '', '', 3306) or die('Failed');"
```

### 4. Run Dry Run
```bash
# Test migration without making changes
php migrate_to_mysql.php --dry-run --verbose
```

### 5. Run Migration
```bash
# Perform actual migration
php migrate_to_mysql.php --verbose
```

### 6. Update Configuration
```php
// In config/database.php, change:
define('DB_TYPE', 'mysql'); // Was 'sqlite'
```

### 7. Test Application
- Login to admin panel
- Check student list
- Test CRUD operations
- Verify public pages

## ⚠️ Important Notes

- **ALWAYS backup before migration!**
- Backup is automatically created in `backups/database/`
- Keep SQLite database for 30 days after migration
- Monitor application for 48 hours after migration

## 🔄 Rollback (if needed)

```php
// In config/database.php, change back:
define('DB_TYPE', 'sqlite'); // Was 'mysql'
```

## 📋 Command Options

```bash
php migrate_to_mysql.php --help       # Show help
php migrate_to_mysql.php --dry-run    # Test without changes
php migrate_to_mysql.php --verbose    # Show detailed output
php migrate_to_mysql.php --force      # Skip confirmations
```

## 🆘 Quick Troubleshooting

| Issue | Solution |
|-------|----------|
| Cannot connect to MySQL | Start MySQL in XAMPP Control Panel |
| Access denied | Check credentials in config/database.php |
| Extension not loaded | Enable mysqli in php.ini, restart Apache |
| Record count mismatch | Check migration log, re-run if needed |

## 📁 Important Files

- `migrate_to_mysql.php` - Migration script
- `config/database.php` - Database configuration
- `migration_log_*.txt` - Detailed log
- `migration_report_*.txt` - Summary report
- `backups/database/` - SQLite backups

## 📖 Full Documentation

See `MYSQL_MIGRATION_GUIDE.md` for complete instructions and troubleshooting.

---

**Need Help?** Check the migration log files for detailed error messages.
