# Panduan Backup Website Sekolah

## Cara Menggunakan Sistem Backup

### 1. Backup Manual (Via Browser)

Akses URL berikut di browser:
```
https://namadomain.com/backup.php?key=your-secret-backup-key-123
```

**PENTING**: Ganti `your-secret-backup-key-123` dengan key rahasia Anda di file `backup.php` baris 12!

### 2. Backup Otomatis (Cron Job)

#### A. Via cPanel Cron Jobs

1. Login ke cPanel
2. Cari menu "Cron Jobs"
3. Tambahkan cron job baru:

**Untuk backup harian (setiap hari jam 2 pagi):**
```
0 2 * * * /usr/bin/php /home/username/public_html/backup.php?key=your-secret-backup-key-123
```

**Untuk backup mingguan (setiap Minggu jam 3 pagi):**
```
0 3 * * 0 /usr/bin/php /home/username/public_html/backup.php?key=your-secret-backup-key-123
```

#### B. Via wget/curl (alternatif)

```bash
0 2 * * * wget -q -O /dev/null "https://namadomain.com/backup.php?key=your-secret-backup-key-123"
```

atau

```bash
0 2 * * * curl -s "https://namadomain.com/backup.php?key=your-secret-backup-key-123" > /dev/null
```

### 3. Struktur Backup

Backup akan disimpan di folder:
```
backups/
├── 2024-01-15/
│   ├── school_2024-01-15_02-00-00.db
│   └── uploads_2024-01-15_02-00-00.zip
├── 2024-01-16/
│   ├── school_2024-01-16_02-00-00.db
│   └── uploads_2024-01-16_02-00-00.zip
└── ...
```

### 4. Restore Backup

#### Restore Database:

1. Download file backup `.db` dari folder `backups/`
2. Stop website (maintenance mode)
3. Backup database lama (safety)
4. Replace file `data/school.db` dengan backup
5. Set permission: `chmod 644 data/school.db`
6. Test website

#### Restore Uploads:

1. Download file backup `.zip` dari folder `backups/`
2. Extract file ZIP
3. Upload ke folder `data/uploads/`
4. Set permission: `chmod 755 data/uploads/`

### 5. Download Backup ke Local

#### Via FTP:
1. Connect ke FTP
2. Navigate ke folder `backups/`
3. Download folder tanggal yang diinginkan

#### Via cPanel File Manager:
1. Login cPanel
2. File Manager → backups/
3. Compress folder tanggal
4. Download ZIP file

### 6. Monitoring Backup

Cek hasil backup dengan mengakses:
```
https://namadomain.com/backup.php?key=your-secret-backup-key-123
```

Response JSON akan menampilkan:
```json
{
    "database": {
        "status": "success",
        "file": "/path/to/backup.db",
        "size": "2.5 MB"
    },
    "uploads": {
        "status": "success",
        "file": "/path/to/uploads.zip",
        "size": "15.3 MB",
        "files": 45
    },
    "cleanup": {
        "status": "success",
        "deleted": 2,
        "retention_days": 30
    },
    "summary": {
        "timestamp": "2024-01-15 02:00:00",
        "backup_dir": "/path/to/backups/2024-01-15",
        "total_backups": 30
    }
}
```

### 7. Retensi Backup

- Backup otomatis disimpan selama **30 hari**
- Backup lebih dari 30 hari akan dihapus otomatis
- Untuk mengubah retensi, edit `$retentionDays` di `backup.php` baris 95

### 8. Tips Keamanan

1. **Ganti Secret Key**: Ubah `your-secret-backup-key-123` dengan string random yang kuat
2. **Proteksi Folder Backup**: Folder `backups/` sudah diproteksi via `.htaccess`
3. **Download Berkala**: Download backup ke komputer lokal secara berkala
4. **Test Restore**: Test restore backup minimal 1x per bulan
5. **Multiple Location**: Simpan backup di multiple lokasi (server, cloud, local)

### 9. Troubleshooting

#### Backup gagal - Permission denied
```bash
chmod 755 backups/
chmod 755 data/
```

#### ZIP tidak tersedia
Jika hosting tidak support ZipArchive, backup uploads akan di-skip. Backup manual via FTP.

#### Cron job tidak jalan
- Cek cron job syntax
- Cek path PHP: `which php` atau `/usr/bin/php`
- Cek error log cPanel

### 10. Backup Manual Alternatif

#### Via SSH:
```bash
# Backup database
cp data/school.db backups/manual_$(date +%Y%m%d).db

# Backup uploads
tar -czf backups/uploads_$(date +%Y%m%d).tar.gz data/uploads/
```

#### Via phpMyAdmin (jika migrasi ke MySQL):
Export database → SQL format → Download

---

## Checklist Backup Rutin

- [ ] Setup cron job untuk backup otomatis
- [ ] Test backup manual pertama kali
- [ ] Download backup ke local storage
- [ ] Test restore di development environment
- [ ] Dokumentasikan lokasi backup
- [ ] Set reminder untuk cek backup bulanan

---

**Dibuat**: <?php echo date('Y-m-d'); ?>  
**Versi**: 1.0


---

## 🗄️ Backup Database (SQLite)

### Format Backup Database

Sistem menyediakan 3 format backup database:

#### 1. SQLite Binary (.db)
- ✅ Backup paling cepat
- ✅ Restore instant (copy file)
- ✅ Ukuran file kecil
- ❌ Hanya untuk SQLite

#### 2. SQLite SQL (.sql)
- ✅ Bisa dibaca dan diedit
- ✅ Portable antar sistem
- ❌ Tidak compatible dengan MySQL

#### 3. MySQL SQL (.sql) ⭐ **RECOMMENDED untuk phpMyAdmin**
- ✅ **Compatible dengan phpMyAdmin** ✓
- ✅ **Bisa di-import ke MySQL/MariaDB** ✓
- ✅ Syntax standar MySQL
- ✅ Bisa dibaca dan diedit

### Cara Backup Database untuk phpMyAdmin

1. Login ke **Admin Panel**
2. Klik menu **"Backup & Restore Database"**
3. Di bagian **"Backup Format SQL (.sql)"**:
   - Pilih radio button **"MySQL/MariaDB SQL"**
   - Klik tombol **"Backup Format SQL (.sql)"**
4. Download file backup yang dihasilkan
5. Upload ke phpMyAdmin

### Panduan Lengkap

Untuk panduan lengkap cara upload backup ke phpMyAdmin, lihat:
📖 **[MYSQL_BACKUP_GUIDE.md](MYSQL_BACKUP_GUIDE.md)**

Panduan tersebut mencakup:
- Cara membuat backup MySQL
- Cara upload ke phpMyAdmin (step-by-step)
- Troubleshooting common issues
- Tips & best practices

---

## 📝 Catatan Penting

### Backup Database
- Backup database dilakukan melalui Admin Panel
- Tidak termasuk dalam backup otomatis website
- Harus dilakukan manual atau via script terpisah
- File backup disimpan di folder `backups/database/`

### Backup Website vs Database
- **Backup Website** (`backup.php`): Files, uploads, config
- **Backup Database** (Admin Panel): Data SQLite/MySQL
- Keduanya terpisah dan harus di-backup secara terpisah
