# Implementation Plan

- [x] 1. Create database configuration system





  - Create `config/database.php.example` template file with all MySQL and SQLite configuration options
  - Add `.gitignore` entry to exclude `config/database.php` from version control
  - _Requirements: 2.1, 2.2, 2.3, 2.4_

- [x] 2. Implement MySQL connection wrapper




  - [x] 2.1 Create `MySQLiPDOWrapper` class in `includes/db.php`


    - Implement `prepare()` method that returns statement wrapper
    - Implement `exec()` method for DDL statements
    - Implement `query()` method for simple queries
    - Implement `lastInsertId()` method
    - _Requirements: 1.1, 1.3, 4.1, 4.2_
  
  - [x] 2.2 Update `get_db()` function to support both database types

    - Add configuration file check and error handling
    - Implement MySQL connection branch using MySQLi
    - Maintain existing SQLite connection branch
    - Add connection error handling with user-friendly messages
    - _Requirements: 1.1, 1.4, 2.5, 4.3_

- [x] 3. Create schema conversion utilities






  - [x] 3.1 Implement `convert_sqlite_to_mysql_schema()` function

    - Convert INTEGER PRIMARY KEY AUTOINCREMENT to INT AUTO_INCREMENT
    - Convert TEXT types to appropriate VARCHAR/TEXT/LONGTEXT
    - Convert CURRENT_TIMESTAMP to MySQL format
    - Add ENGINE=InnoDB and CHARSET=utf8mb4 to CREATE TABLE statements
    - _Requirements: 5.1, 5.2, 5.3, 5.4, 5.5_
  

  - [x] 3.2 Implement query syntax translator





    - Convert INSERT OR IGNORE to INSERT IGNORE
    - Convert INSERT OR REPLACE to REPLACE INTO
    - Convert PRAGMA statements to MySQL equivalents
    - Handle backticks for MySQL reserved keywords
    - _Requirements: 6.1, 6.2, 6.3, 6.4, 6.5_

- [x] 4. Build migration script




  - [x] 4.1 Create `migrate_to_mysql.php` main script


    - Implement pre-flight checks (MySQL running, credentials valid, SQLite exists)
    - Add command-line interface with options (--dry-run, --verbose, --force)
    - Implement progress display with percentage and ETA
    - _Requirements: 3.1, 3.2_
  
  - [x] 4.2 Implement SQLite backup functionality


    - Create backup of SQLite database before migration
    - Store backup with timestamp in backups/database/ directory
    - Verify backup file integrity
    - _Requirements: 3.2_
  
  - [x] 4.3 Implement MySQL database creation


    - Connect to MySQL server
    - Create database if not exists with utf8mb4 charset
    - Set proper collation (utf8mb4_unicode_ci)
    - _Requirements: 3.3_
  
  - [x] 4.4 Implement schema migration


    - Read SQLite schema using PRAGMA table_info
    - Convert schema to MySQL format
    - Create all tables in MySQL with proper types and indexes
    - Create indexes and constraints
    - _Requirements: 3.3, 5.1, 5.2, 5.3, 5.4, 5.5_
  
  - [x] 4.5 Implement data migration


    - Migrate data table by table with transaction support
    - Handle BLOB data and special characters
    - Display progress for each table
    - Use batch inserts for performance (100 records per batch)
    - _Requirements: 3.4_
  
  - [x] 4.6 Implement data verification


    - Compare record counts between SQLite and MySQL
    - Verify sample records for data integrity
    - Check for NULL values and data types
    - Generate verification report
    - _Requirements: 3.5, 8.1, 8.2, 8.3_
  
  - [x] 4.7 Implement migration logging and reporting


    - Create detailed log file with timestamp
    - Log all operations, errors, and warnings
    - Generate summary report with statistics
    - Display success/failure status
    - _Requirements: 3.5, 8.4, 8.5_
  
  - [x] 4.8 Implement rollback mechanism


    - Add transaction support for atomic migration
    - Implement rollback on error
    - Display specific error messages
    - Preserve SQLite database on failure
    - _Requirements: 3.6_

- [x] 5. Update initialization script for MySQL


  - [x] 5.1 Update `init_db.php` to detect database type


    - Check DB_TYPE configuration
    - Branch to MySQL or SQLite initialization
    - _Requirements: 10.1_
  
  - [x] 5.2 Implement MySQL database initialization

    - Create MySQL database if not exists
    - Create all tables with MySQL schema
    - Add proper indexes for performance
    - _Requirements: 10.2, 10.3_
  
  - [x] 5.3 Implement default data insertion for MySQL

    - Insert default settings (site_name, etc.)
    - Create default admin account
    - Insert sample student data
    - Create upload directories
    - _Requirements: 10.4, 10.5_

- [ ] 6. Update backup module for MySQL support

  - [ ] 6.1 Add MySQL backup functionality to `admin/database_backup.php`

    - Implement mysqldump integration for fast backups
    - Add PHP-based fallback export method
    - Maintain existing SQLite backup functionality
    - _Requirements: 9.1, 9.2, 9.3_
  
  - [ ] 6.2 Update backup file naming and format
    - Use consistent naming convention for MySQL backups
    - Add database type indicator in filename
    - Store backups in backups/database/ directory
    - _Requirements: 9.4_
  
  - [ ] 6.3 Implement MySQL restore functionality
    - Add restore from SQL file for MySQL
    - Implement transaction-based restore
    - Add verification after restore
    - _Requirements: 9.5_

- [ ] 7. Update query compatibility across application
  - [ ] 7.1 Audit and update admin panel queries
    - Review `admin/students.php` for MySQL compatibility
    - Review `admin/settings.php` for MySQL compatibility
    - Review `admin/users.php` for MySQL compatibility
    - Update PRAGMA table_info queries to SHOW COLUMNS
    - _Requirements: 6.1, 6.2, 6.3, 6.4_
  
  - [ ] 7.2 Audit and update public pages queries
    - Review all public/*.php files for database queries
    - Ensure prepared statements are used consistently
    - Test query performance with MySQL
    - _Requirements: 6.5_
  
  - [ ] 7.3 Update authentication module
    - Verify `includes/auth.php` works with MySQL
    - Test login/logout functionality
    - Test password hashing compatibility
    - _Requirements: 1.3_

- [ ] 8. Create comprehensive documentation
  - [ ] 8.1 Create `MYSQL_MIGRATION_GUIDE.md`
    - Write prerequisites section (MySQL version, PHP extensions)
    - Write step-by-step migration instructions
    - Add configuration examples
    - Include screenshots where helpful
    - _Requirements: 7.1, 7.2_
  
  - [ ] 8.2 Add troubleshooting section to guide
    - Document common connection errors
    - Document migration failure scenarios
    - Add solutions for each issue
    - Include rollback instructions
    - _Requirements: 7.3, 7.4_
  
  - [ ] 8.3 Create verification checklist
    - List all verification steps post-migration
    - Include SQL queries for data validation
    - Add performance comparison tests
    - _Requirements: 7.5_
  
  - [ ] 8.4 Update README.md
    - Add MySQL as supported database
    - Update installation instructions
    - Add link to migration guide
    - Update system requirements
    - _Requirements: 7.1_

- [ ]* 9. Testing and validation
  - [ ]* 9.1 Create test database with sample data
    - Generate SQLite database with 100+ students
    - Add multiple admin accounts
    - Add various settings
    - _Requirements: 8.1, 8.2_
  
  - [ ]* 9.2 Test migration script
    - Run migration with test database
    - Verify all data migrated correctly
    - Test rollback functionality
    - Test dry-run mode
    - _Requirements: 3.1, 3.2, 3.3, 3.4, 3.5, 3.6_
  
  - [ ]* 9.3 Test application functionality with MySQL
    - Test student CRUD operations
    - Test admin authentication
    - Test settings management
    - Test file uploads
    - Test backup/restore
    - _Requirements: 1.1, 1.2, 1.3_
  
  - [ ]* 9.4 Performance testing
    - Benchmark query performance (SQLite vs MySQL)
    - Test concurrent user access
    - Test with large datasets (1000+ records)
    - _Requirements: 1.1_
  
  - [ ]* 9.5 Security testing
    - Test SQL injection prevention
    - Verify password hashing
    - Check configuration file protection
    - Test error message information disclosure
    - _Requirements: 1.4, 2.4_

- [ ] 10. Deployment preparation
  - [ ] 10.1 Create deployment checklist
    - List all pre-deployment tasks
    - Include backup procedures
    - Add rollback plan
    - _Requirements: 7.4_
  
  - [ ] 10.2 Prepare configuration template
    - Create production-ready config template
    - Add security recommendations
    - Include performance tuning tips
    - _Requirements: 2.1, 2.2_
  
  - [ ] 10.3 Create post-deployment monitoring guide
    - Document what to monitor after migration
    - Add performance metrics to track
    - Include error log locations
    - _Requirements: 7.5_
