# Requirements Document

## Introduction

This document outlines the requirements for migrating the MyGB school management system from SQLite database to MySQL/MySQLi. The migration aims to improve scalability, performance for concurrent users, and provide better support for production environments while maintaining all existing functionality and data integrity.

## Glossary

- **MyGB System**: The school management web application currently using SQLite database
- **SQLite**: File-based relational database currently used by the system
- **MySQL**: Server-based relational database management system (target database)
- **MySQLi**: MySQL Improved extension for PHP providing both procedural and object-oriented interfaces
- **PDO**: PHP Data Objects - database abstraction layer currently used with SQLite
- **Migration Script**: Automated tool to transfer data from SQLite to MySQL
- **Database Connection Layer**: The `includes/db.php` file that provides database connectivity
- **Schema**: Database structure including tables, columns, indexes, and constraints
- **XAMPP**: Local development environment providing Apache, MySQL, and PHP

## Requirements

### Requirement 1

**User Story:** As a system administrator, I want the application to use MySQL database instead of SQLite, so that the system can handle multiple concurrent users efficiently and scale for production use.

#### Acceptance Criteria

1. WHEN the system starts, THE MyGB System SHALL establish connection to MySQL server using MySQLi extension
2. THE MyGB System SHALL store all application data in MySQL database named `mygb_school`
3. THE MyGB System SHALL maintain backward compatibility with existing PDO-style query patterns where feasible
4. THE MyGB System SHALL provide clear error messages when MySQL connection fails
5. WHERE MySQL server is unavailable, THE MyGB System SHALL display user-friendly error message with troubleshooting guidance

### Requirement 2

**User Story:** As a system administrator, I want a configuration file for database credentials, so that I can easily configure the database connection for different environments without modifying code.

#### Acceptance Criteria

1. THE MyGB System SHALL read database configuration from `config/database.php` file
2. THE configuration file SHALL contain MySQL host, database name, username, password, and charset settings
3. THE MyGB System SHALL provide a template configuration file `config/database.php.example` with placeholder values
4. THE MyGB System SHALL exclude actual `config/database.php` from version control via `.gitignore`
5. WHERE configuration file is missing, THE MyGB System SHALL display setup instructions to the user

### Requirement 3

**User Story:** As a system administrator, I want an automated migration script, so that I can transfer all existing SQLite data to MySQL database without manual data entry.

#### Acceptance Criteria

1. THE MyGB System SHALL provide a migration script `migrate_to_mysql.php` in the root directory
2. WHEN migration script executes, THE Migration Script SHALL read all data from SQLite database file
3. WHEN migration script executes, THE Migration Script SHALL create MySQL database schema with proper data types
4. WHEN migration script executes, THE Migration Script SHALL transfer all records from SQLite to MySQL preserving data integrity
5. THE Migration Script SHALL provide progress feedback and completion status to the user
6. IF migration fails, THEN THE Migration Script SHALL display specific error message and rollback changes

### Requirement 4

**User Story:** As a developer, I want the database connection layer to support both SQLite and MySQL, so that I can test the migration without breaking the existing system.

#### Acceptance Criteria

1. THE Database Connection Layer SHALL detect database type from configuration
2. WHERE configuration specifies MySQL, THE Database Connection Layer SHALL use MySQLi connection
3. WHERE configuration specifies SQLite, THE Database Connection Layer SHALL use PDO SQLite connection
4. THE Database Connection Layer SHALL provide unified interface for both database types
5. THE Database Connection Layer SHALL handle database-specific syntax differences transparently

### Requirement 5

**User Story:** As a system administrator, I want the MySQL schema to use appropriate data types, so that the database performs optimally and maintains data integrity.

#### Acceptance Criteria

1. THE MySQL Schema SHALL convert SQLite `INTEGER PRIMARY KEY AUTOINCREMENT` to MySQL `INT AUTO_INCREMENT PRIMARY KEY`
2. THE MySQL Schema SHALL convert SQLite `TEXT` columns to appropriate MySQL types (`VARCHAR`, `TEXT`, `LONGTEXT`)
3. THE MySQL Schema SHALL use `utf8mb4` character set for proper Unicode support
4. THE MySQL Schema SHALL use `InnoDB` storage engine for transaction support
5. THE MySQL Schema SHALL maintain all foreign key relationships and constraints from SQLite schema

### Requirement 6

**User Story:** As a developer, I want all existing queries to work with MySQL, so that the application functions correctly after migration without extensive code changes.

#### Acceptance Criteria

1. THE MyGB System SHALL replace SQLite-specific `AUTOINCREMENT` with MySQL `AUTO_INCREMENT` in CREATE statements
2. THE MyGB System SHALL replace SQLite `CURRENT_TIMESTAMP` with MySQL-compatible datetime functions
3. THE MyGB System SHALL handle MySQL reserved keywords by using backticks where necessary
4. THE MyGB System SHALL convert SQLite `PRAGMA` statements to MySQL equivalents
5. WHERE query syntax differs between SQLite and MySQL, THE Database Connection Layer SHALL translate queries automatically

### Requirement 7

**User Story:** As a system administrator, I want comprehensive documentation for the migration process, so that I can successfully migrate the system without technical assistance.

#### Acceptance Criteria

1. THE MyGB System SHALL provide migration guide document `MYSQL_MIGRATION_GUIDE.md`
2. THE migration guide SHALL include step-by-step instructions for database setup
3. THE migration guide SHALL include troubleshooting section for common issues
4. THE migration guide SHALL include rollback instructions if migration fails
5. THE migration guide SHALL include verification steps to confirm successful migration

### Requirement 8

**User Story:** As a system administrator, I want to verify that all data migrated correctly, so that I can ensure no data loss occurred during migration.

#### Acceptance Criteria

1. THE Migration Script SHALL display record count comparison between SQLite and MySQL
2. THE Migration Script SHALL verify that all tables were created successfully
3. THE Migration Script SHALL check that all indexes and constraints exist in MySQL
4. THE Migration Script SHALL create a migration log file with timestamp and results
5. IF record counts do not match, THEN THE Migration Script SHALL display warning message with details

### Requirement 9

**User Story:** As a developer, I want the backup functionality to work with MySQL, so that administrators can continue backing up their data after migration.

#### Acceptance Criteria

1. THE MyGB System SHALL update backup module `admin/database_backup.php` to support MySQL
2. WHEN backup executes, THE Backup Module SHALL export MySQL database to SQL file
3. THE Backup Module SHALL use `mysqldump` utility for efficient MySQL backups
4. THE Backup Module SHALL maintain existing backup file naming convention
5. THE Backup Module SHALL provide restore functionality for MySQL backups

### Requirement 10

**User Story:** As a system administrator, I want the setup/initialization script to work with MySQL, so that I can deploy fresh installations using MySQL database.

#### Acceptance Criteria

1. THE MyGB System SHALL update `init_db.php` to support MySQL database initialization
2. WHEN initialization executes, THE Initialization Script SHALL create MySQL database if not exists
3. WHEN initialization executes, THE Initialization Script SHALL create all required tables with proper schema
4. WHEN initialization executes, THE Initialization Script SHALL insert default settings and sample data
5. THE Initialization Script SHALL create default admin account with secure password hashing
